/* FILE: mevent.c                               (D. Tottingham  12/26/90)

This is a collection of C functions that manage events for xdetect.
As of now, this entails managing the event warning bell.  Eventually, this
module will contain a full-featured event manager.  All functions have been
written and compiled medium model.  The following functions are included:

e_initialize ()                 initialize event parameters
e_get_bell_status ()            get bell_enabled
e_set_bell_status ()            set bell_enabled
e_ring_bell ()                  ring event alert bell if enabled
e_toggle_bell_status ()         toggle bell_enabled


EXTERNAL FUNCTIONS CALLED:
   none


HISTORY:
   none

*/


/*************************************************************************
                            INCLUDE FILES

*************************************************************************/
#include <stdio.h>

#include "mconst.h"
#include "mevent.h"


/*************************************************************************
                                GLOBALS

*************************************************************************/
PRIVATE FLAG bell_enabled;


/*=======================================================================*
 *                             e_initialize                              *
 *=======================================================================*/
/* Initialize event parameters.                                          */

PUBLIC
void e_initialize ()
{
   bell_enabled = BELL_ENABLED;
}

/*=======================================================================*
 *                           e_get_bell_status                           *
 *=======================================================================*/
/* Get bell_enabled.                                                     */

PUBLIC
FLAG e_get_bell_status ()
{
   return bell_enabled;
}

/*=======================================================================*
 *                           e_set_bell_status                           *
 *=======================================================================*/
/* Set bell_enabled.                                                     */

PUBLIC
void e_set_bell_status (bell_status)
FLAG bell_status;
{
   bell_enabled = bell_status;
}

/*=======================================================================*
 *                              e_ring_bell                              *
 *=======================================================================*/
/* Ring event alert bell if enabled.                                     */

PUBLIC
void e_ring_bell ()
{
   if (bell_enabled)
      printf ("\a");
}

/*=======================================================================*
 *                         e_toggle_bell_status                          *
 *=======================================================================*/
/* Toggle bell_enabled.                                                  */

PUBLIC
void e_toggle_bell_status ()
{
   bell_enabled = (bell_enabled) ? FALSE : TRUE;
}
